package com.yizhi.training.application.controller;


import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.orm.hierarchicalauthorization.HQueryUtil;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.training.application.constant.ProjectConstant;
import com.yizhi.training.application.domain.TpClassification;
import com.yizhi.training.application.service.ITpClassificationService;
import com.yizhi.training.application.service.ITrainingProjectService;
import com.yizhi.training.application.vo.domain.TpClassificationVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 培训项目分类表 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
@RestController
@RequestMapping("/tpClassification")
public class TpClassificationController {

    @Autowired
    ITpClassificationService iTpClassificationService;

    @Autowired
    ITrainingProjectService iTrainingProjectService;

    @Autowired
    IdGenerator idGenerator;

    @ApiOperation("分类列表查询")
    @GetMapping(value = "/list")
    public List<TpClassification> list(@RequestBody RequestContext context) {

        TpClassification classification = new TpClassification();
        classification.setSiteId(context.getSiteId());
        classification.setCompanyId(context.getCompanyId());
        classification.setDeleted(ProjectConstant.DELETED_NO);
        EntityWrapper<TpClassification> entityWrapper = new EntityWrapper<>(classification);

//        if (!context.isAdmin() && !CollectionUtils.isEmpty(context.getOrgIds())) {
//            entityWrapper.in("org_id", context.getOrgIds());
//        }
        HQueryUtil.startHQ(TpClassification.class);
        return iTpClassificationService.selectList(entityWrapper);
    }

    @ApiOperation("分类保存")
    @PostMapping(value = "/save")
    public Boolean save(@RequestBody TpClassificationVo tpClassification) {
        tpClassification.setId(idGenerator.generate());
        TpClassification tc=new TpClassification();
        BeanUtils.copyProperties(tpClassification,tc);
        Boolean f = iTpClassificationService.insert(tc);
        return f;
    }

    @ApiOperation("分类修改")
    @PostMapping(value = "/update")
    public Boolean update(@RequestBody TpClassificationVo tpClassification) {
        TpClassification tc=new TpClassification();
        BeanUtils.copyProperties(tpClassification,tc);
        Boolean f = iTpClassificationService.updateAllColumnById(tc);
        return f;
    }

    @ApiOperation("分类根据id查询")
    @GetMapping(value = "/view")
    public TpClassification view(@RequestParam("id") Long id) {
        TpClassification classification = iTpClassificationService.selectById(id);
        return classification;
    }

    /**
     * 分类逻辑删除  删除之前将关联的项目改为未分类
     *
     * @param param 接参实体 只取id
     * @return 布尔值  true删除成功 false 删除失败
     */
    @PostMapping(value = "delete")
    public Boolean tpClassificationDelete(@RequestBody TpClassificationVo param) {
        TpClassification tc=new TpClassification();
        BeanUtils.copyProperties(param,tc);
        return iTpClassificationService.delete(tc);
    }


}

