package com.yizhi.training.application.controller;


import java.util.List;

import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.training.application.domain.TpCommentThumbsUp;
import com.yizhi.training.application.service.ITpCommentThumbsUpService;
import com.yizhi.training.application.vo.domain.TpCommentThumbsUpVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.baomidou.mybatisplus.mapper.EntityWrapper;

/**
 * <p>
 * 评论点赞记录 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
@RestController
@RequestMapping("/tpCommentThumbsUp")
public class TpCommentThumbsUpController {

    @Autowired
    ITpCommentThumbsUpService iTpCommentThumbsUpService;

    @Autowired
    IdGenerator idGenerator;

    @PostMapping("/save")
    public Boolean save(@RequestBody TpCommentThumbsUpVo tpCommentThumbsUp) {
        TpCommentThumbsUp tct=new TpCommentThumbsUp();
        BeanUtils.copyProperties(tpCommentThumbsUp,tct);
        EntityWrapper<TpCommentThumbsUp> entityWrapper = new EntityWrapper<TpCommentThumbsUp>(tct);
        List<TpCommentThumbsUp> list = iTpCommentThumbsUpService.selectList(entityWrapper);
        if (list.size() > 0) {
            return Boolean.FALSE;
        }
        tct.setId(idGenerator.generate());
        Boolean f = iTpCommentThumbsUpService.insert(tct);
        return f;
    }

    @PostMapping("/delete")
    public Boolean delete(@RequestBody TpCommentThumbsUpVo tpCommentThumbsUp) {
        TpCommentThumbsUp tct=new TpCommentThumbsUp();
        BeanUtils.copyProperties(tpCommentThumbsUp,tct);
        EntityWrapper<TpCommentThumbsUp> entityWrapper = new EntityWrapper<TpCommentThumbsUp>(tct);
        Boolean f = iTpCommentThumbsUpService.delete(entityWrapper);
        return f;
    }

    @GetMapping("/count")
    public Integer countThumbsUp(@RequestParam(value = "commentId 评论id")Long commentId) {

       return iTpCommentThumbsUpService.countThumbsUp(commentId);
    }


}

