package com.yizhi.training.application.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.training.application.domain.LeaveWord;
import com.yizhi.training.application.mapper.LeaveWordMapper;
import com.yizhi.training.application.service.LeaveWordService;
import com.yizhi.training.application.vo.domain.LeaveWordParamVo;
import com.yizhi.training.application.vo.domain.LeaveWordVo;
import com.yizhi.training.application.vo.domain.AuthzUserGroupVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * com.yizhi.training.application.service.impl
 *
 * @author yanglang
 * @create 2025-01-03 10:06:26
 */
@Service
public class LeaveWordServiceImpl extends ServiceImpl<LeaveWordMapper, LeaveWord> implements LeaveWordService {


    @Autowired
    private IdGenerator idGenerator;

    @Autowired
    private 
    LeaveWordMapper leaveWordMapper;
    
    @Override
    public Page<LeaveWordVo> page(LeaveWordParamVo paramVo){
        Page<LeaveWordVo> page = new Page(paramVo.getPageNo(), paramVo.getPageSize());
        Page<LeaveWord> paramPage = new Page(paramVo.getPageNo(), paramVo.getPageSize());
        EntityWrapper<LeaveWord> map = new EntityWrapper<LeaveWord>();
        RequestContext context = new RequestContext();//ContextHolder.get();
        context.setSiteId(1635853066584846336L);
        map.eq("site_id",context.getSiteId());
        if(ObjectUtil.isNotEmpty(paramVo.getName())){
            map.like("name", paramVo.getName());

        }
        if(ObjectUtil.isNotEmpty(paramVo.getBizType())){
            map.eq("biz_type", paramVo.getBizType());
        }
        if(ObjectUtil.isNotEmpty(paramVo.getCreateByName())){
            map.like("create_by_name", paramVo.getCreateByName());
        }
        if(ObjectUtil.isNotEmpty(paramVo.getCreateById())){
            map.eq("create_by_id", paramVo.getCreateById());
        }
        if(ObjectUtil.isNotEmpty(paramVo.getState())){
            map.eq("state", paramVo.getState());
        }
        List<String> list = new ArrayList<String>();
        list.add("createTime");
        map.orderDesc(list);
        paramPage = selectPage(paramPage,map);
        if(paramPage!=null){
            page.setSize(paramPage.getSize());
            List<LeaveWord> leaveWordList = paramPage.getRecords();
            List<LeaveWordVo> leaveWordVoList = Lists.newArrayList();
            if(CollUtil.isNotEmpty(leaveWordList)){
                List<Long> groupIds = leaveWordList.stream().filter(l->l.getGroupId()!=null).map(LeaveWord::getGroupId).collect(Collectors.toList());
                Map<Long,AuthzUserGroupVo> groupVoMap = Maps.newHashMap();
                if(CollUtil.isNotEmpty(groupIds)){
                    List<AuthzUserGroupVo>  authzUserGroupVoList = this.baseMapper.queryUserGroupByIds(groupIds);
                    if(CollUtil.isNotEmpty(authzUserGroupVoList)){
                        groupVoMap = authzUserGroupVoList.stream().collect(Collectors.toMap(AuthzUserGroupVo::getId,a->a));
                    }
                }
                
                List<Long> accountIds = new ArrayList<Long>();
                Map<Long, AuthzUserGroupVo> finalGroupVoMap = groupVoMap;
                leaveWordList.stream().forEach(leaveWord -> {
                    LeaveWordVo leaveWordVo = new LeaveWordVo();
                    BeanUtil.copyProperties(leaveWord,leaveWordVo);
                    if(leaveWord.getGroupId()!=null&&finalGroupVoMap.containsKey(leaveWord.getGroupId())){
                        AuthzUserGroupVo groupVo = finalGroupVoMap.get(leaveWord.getGroupId());
                        leaveWordVo.setGroupName(groupVo.getName());
                        leaveWordVo.setOrgName(groupVo.getDescription());
                        leaveWordVoList.add(leaveWordVo);
                        
                        accountIds.add(leaveWordVo.getCreateById());
                    }
                });
                
                //设置姓名
                if(CollUtil.isNotEmpty(accountIds)) {
                	Map<Long, Map<Long, String>> accountMap = leaveWordMapper.queryAccountNameByIds(accountIds);
                    if(accountMap != null){
                    	leaveWordVoList.stream().forEach(leaveWord -> {
                    		if(accountMap.get(leaveWord.getCreateById()) != null){
                    			leaveWord.setFullName(accountMap.get(leaveWord.getCreateById()).get("fullName"));
                    		}
                    	 });
                    }
                }
            }
            page.setRecords(leaveWordVoList);
        }

        return page;
    }

    @Override
    public boolean save(LeaveWordVo leaveWordVo){
        LeaveWord leaveWord = new LeaveWord();
        BeanUtil.copyProperties(leaveWordVo,leaveWord);
        RequestContext context = ContextHolder.get();
        Date now = new Date();
        leaveWord.setUpdateById(context.getAccountId());
        leaveWord.setUpdateByName(context.getAccountName());
        leaveWord.setUpdateTime(now);
        leaveWord.setDeleted(0);
        if(leaveWord.getId()==null){
            leaveWord.setId(idGenerator.generate());
            leaveWord.setCreateById(context.getAccountId());
            leaveWord.setCreateByName(context.getAccountName());
            leaveWord.setCreateTime(now);
            leaveWord.setState(1);
            AuthzUserGroupVo authzUserGroupVo = this.baseMapper.getUserGroupByUser(context.getAccountId());
            if(authzUserGroupVo!=null){
                leaveWord.setSiteId(authzUserGroupVo.getSiteId());
                leaveWord.setCompanyId(authzUserGroupVo.getCompanyId());
                leaveWord.setGroupId(authzUserGroupVo.getId());
            }
           return this.insert(leaveWord);
        }else{
           return this.updateById(leaveWord);
        }
    }

    @Override
    public AuthzUserGroupVo getAuthzUserGroup(Long userId){
        return this.baseMapper.getUserGroupByUser(userId);
    }

    @Override
    public LeaveWordVo getById(Long id) {
        LeaveWord leaveWord = this.selectById(id);
        if(leaveWord==null){
            return null;
        }
        LeaveWordVo leaveWordVo = new LeaveWordVo();
        BeanUtil.copyProperties(leaveWord,leaveWordVo);
        if(leaveWord.getGroupId()!=null) {
            AuthzUserGroupVo authzUserGroupVo = this.baseMapper.getUserGroupById(leaveWord.getGroupId());
            if(authzUserGroupVo!=null){
                leaveWordVo.setGroupName(authzUserGroupVo.getName());
                leaveWordVo.setOrgName(authzUserGroupVo.getDescription());
            }
        }
        return leaveWordVo;
    }

    @Override
    public boolean updateState(Long id,Integer state) {
        LeaveWord leaveWord = this.selectById(id);
        if(leaveWord==null){
            return false;
        }
        RequestContext context = ContextHolder.get();
        Date now = new Date();
        leaveWord.setState(state);
        if(Objects.equals(state,2)){
            leaveWord.setAcceptTime(now);
        }
        leaveWord.setUpdateById(context.getAccountId());
        leaveWord.setUpdateByName(context.getAccountName());
        leaveWord.setUpdateTime(now);
        return this.updateById(leaveWord);
    }

    @Override
    public boolean removeById(Long id) {
        LeaveWord leaveWord = this.selectById(id);
        if(leaveWord==null){
            return false;
        }
        leaveWord.setDeleted(1);
        RequestContext context = ContextHolder.get();
        Date now = new Date();
        leaveWord.setUpdateById(context.getAccountId());
        leaveWord.setUpdateByName(context.getAccountName());
        leaveWord.setUpdateTime(now);
        return this.updateById(leaveWord);
    }
}
