package com.yizhi.training.application.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.training.application.domain.TpComment;
import com.yizhi.training.application.mapper.TpCommentMapper;
import com.yizhi.training.application.service.ITpCommentService;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.training.application.vo.manage.PageCommentVo;

import java.util.List;

import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 培训项目 - 评论 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
@Service
public class TpCommentServiceImpl extends ServiceImpl<TpCommentMapper, TpComment> implements ITpCommentService {

    @Override
    public Page<PageCommentVo> getCommentPage(Long createById,Long trainingProjectId, Integer bizType, Long accountId, int pageNo, int pageSize, int type) {
        Page<PageCommentVo> page = new Page<PageCommentVo>(pageNo, pageSize);
        page.setRecords(this.baseMapper.searchPage(createById,trainingProjectId, bizType, accountId, new RowBounds(page.getOffset(), page.getLimit()),type));
        Integer count = this.baseMapper.searchPageCount(createById,trainingProjectId, bizType, accountId,type);
        page.setTotal(count);
        return page;
    }
    
    @Override
    public List<PageCommentVo> getList(Long createById,Long trainingProjectId, Integer bizType, Long accountId){
    	List<PageCommentVo> list = this.baseMapper.getList(createById,trainingProjectId, bizType, accountId);
    	return list;
    }
}
