package com.yizhi.training.application.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class LegacyDateUtils {
    /**
     * 获取两个日期间的所有日期（包含起止日期）
     * @param start 起始日期（格式：yyyy-MM-dd）
     * @param end   结束日期（格式：yyyy-MM-dd）
     * @return 日期字符串列表，格式：yyyy-MM-dd
     */
    public static List<String> getDatesBetween(Date start, Date end) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        List<String> dates = new ArrayList<>();
        try {
            
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(start);
            
            //结束时间的时分秒统一为23:59:59，不然会少最后一天的（某天的 05:00:00至某天的04:00:00）
            SimpleDateFormat formatEnd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            end = formatEnd.parse(format.format(end) + " 23:59:59");
            while (!calendar.getTime().after(end)) {
                dates.add(format.format(calendar.getTime()));
                calendar.add(Calendar.DATE, 1);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return dates;
    }
}
